"use strict";
exports.id = 0;
exports.ids = [0];
exports.modules = {

/***/ 4000:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Iu": () => (/* binding */ translate),
  "O9": () => (/* binding */ translateText)
});

// UNUSED EXPORTS: avoidRateLimit, flatArray, safeParseJSON

;// CONCATENATED MODULE: ./common/locales/en.ts
/* harmony default export */ const en = ({
  home: {},
  portfolio: {
    viewButton: "View Project",
    cta: "Get Started"
  }
});
;// CONCATENATED MODULE: ./common/locales/bn.ts
/* harmony default export */ const bn = ({
  home: {},
  portfolio: {
    viewButton: "দেখুন",
    cta: "যোগাযোগ করুন"
  }
});
;// CONCATENATED MODULE: ./common/helpers.ts
/* @ts-ignore */

/* @ts-ignore */


const translate = (locale, key, params = null) => {
  if (locale === "bn") {
    /* @ts-ignore */
    return getValue(bn, key, params);
  } else {
    /* @ts-ignore */
    return getValue(en, key, params);
  }
};

function getValue(locale, key, params = null) {
  let keys = key.split(".");
  let test = locale;
  keys.forEach(i => {
    test = test[i];
  }); // currently not needed as params will be empty always

  if (params !== null) {
    let stripped = test;
    Object.keys(params).forEach(j => {
      stripped = stripped.replace(`{${j}}`, params[j]);
    });
    return stripped;
  } else {
    return test || key;
  }
}

const translateText = (lang, item, key = "title") => {
  if (typeof item === "undefined" || item === null) {
    return "";
  }

  return lang === "en" ? item[key + "_en"] : item[key + "_bn"];
};
const flatArray = arr => {
  const flat = [];
  arr.map(p => {
    if (p.children) {
      p.children.map(cp => {
        flat.push(cp);
      });
      p.children = [];
    }

    flat.push(p);
  });
  return flat;
};
const safeParseJSON = jsonString => {
  try {
    return JSON.parse(jsonString);
  } catch (error) {
    return null;
  }
};
async function avoidRateLimit(ms = 1000) {
  if (true) {
    await sleep(ms);
  }
}

function sleep(ms = 1000) {
  return new Promise(res => setTimeout(res, ms));
}

/***/ })

};
;