"use strict";
exports.id = 216;
exports.ids = [216];
exports.modules = {

/***/ 2050:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "A": () => (/* binding */ getRequest),
/* harmony export */   "j": () => (/* binding */ postRequest)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2167);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);

axios__WEBPACK_IMPORTED_MODULE_0___default().interceptors.request.use(function (config) {
  return config;
}, function (err) {
  return Promise.reject(err);
});
const getRequest = async url => {
  let response;

  try {
    response = await axios__WEBPACK_IMPORTED_MODULE_0___default().get(url);
    return response;
  } catch (err) {
    if (axios__WEBPACK_IMPORTED_MODULE_0___default().isAxiosError(err) && err.response) {
      return err.response;
    }
  }
};
const postRequest = async (url, data) => {
  let response;

  try {
    response = await axios__WEBPACK_IMPORTED_MODULE_0___default().post(url, data);
    return response;
  } catch (err) {
    if (axios__WEBPACK_IMPORTED_MODULE_0___default().isAxiosError(err) && err.response) {
      return err.response;
    }
  }
};

/***/ }),

/***/ 5330:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _contexts_UiContextProvider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5248);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




const useSiteSetting = props => {
  const [UiState, setUiState] = (0,_contexts_UiContextProvider__WEBPACK_IMPORTED_MODULE_1__/* .useUiState */ .tN)();
  const {
    0: setting,
    1: setSetting
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(UiState.setting);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setUiState(prev => {
      return _objectSpread(_objectSpread({}, prev), {}, {
        setting
      });
    });
    return () => {};
  }, [setUiState, setting]);
  return [setting, setSetting];
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSiteSetting);

/***/ }),

/***/ 9274:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "R": () => (/* binding */ variables),
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const baseUrl = "https://webapi.softwindtech.com/v1";
const variables = {
  apiUrls: {
    baseUrl: baseUrl,
    getPageData: `${baseUrl}/pages/`,
    getSiteMap: `${baseUrl}/sitemap`,
    getSiteSetting: `${baseUrl}/site-setting`,
    getSinglePortfolio: `${baseUrl}/portfolio/`,
    getSingleService: `${baseUrl}/service/`,
    postContact: `${baseUrl}/contact`
  },
  statusCodes: {
    successCode: "400200",
    validationError: "400300"
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (variables);

/***/ })

};
;