"use strict";
exports.id = 26;
exports.ids = [26];
exports.modules = {

/***/ 769:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(358);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5641);
/* harmony import */ var _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1908);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1187);
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_toastify__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _common_API__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2050);
/* harmony import */ var _common_variables__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9274);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_3__]);
([react_hook_form__WEBPACK_IMPORTED_MODULE_2__, _hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











const validationSchema = yup__WEBPACK_IMPORTED_MODULE_4__.object({
  name: yup__WEBPACK_IMPORTED_MODULE_4__.string().required("Name is required"),
  email: yup__WEBPACK_IMPORTED_MODULE_4__.string().email("Must be a valid email").required("Email is required"),
  company_name: yup__WEBPACK_IMPORTED_MODULE_4__.string().required("Company name is required")
}).required();

const PortfolioContactForm = () => {
  var _errors$name, _errors$name2, _errors$email, _errors$email2, _errors$company_name, _errors$company_name2;

  const {
    0: loading,
    1: setLoading
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const {
    register,
    handleSubmit,
    formState: {
      errors
    },
    reset
  } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_2__.useForm)({
    resolver: (0,_hookform_resolvers_yup__WEBPACK_IMPORTED_MODULE_3__.yupResolver)(validationSchema)
  });

  const onSubmit = async data => {
    setLoading(true);

    try {
      let postData = {};
      postData.name = data.name;
      postData.company = data.company_name;
      postData.email = data.email;
      postData.phone = data.phone;
      postData.message = data.message; // send data to backend

      const res = await (0,_common_API__WEBPACK_IMPORTED_MODULE_6__/* .postRequest */ .j)(_common_variables__WEBPACK_IMPORTED_MODULE_7__/* ["default"].apiUrls.postContact */ .Z.apiUrls.postContact, postData);

      if ((res === null || res === void 0 ? void 0 : res.data.statusCode) === _common_variables__WEBPACK_IMPORTED_MODULE_7__/* ["default"].statusCodes.successCode */ .Z.statusCodes.successCode) {
        react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.success(res.data.message);
        reset();
      } else if ((res === null || res === void 0 ? void 0 : res.data.statusCode) === _common_variables__WEBPACK_IMPORTED_MODULE_7__/* ["default"].statusCodes.validationError */ .Z.statusCodes.validationError) {
        const msg = Object.values(res.data.message).flat(Infinity).join("");
        react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.error(msg);
      } else {
        react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.error("Something went wrong. Please try again!");
      } //reset form field


      setLoading(false);
    } catch (err) {
      react_toastify__WEBPACK_IMPORTED_MODULE_5__.toast.error("Something went wrong. Please try again!");
      setLoading(false);
    }
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form, {
    onSubmit: handleSubmit(onSubmit),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Group, {
      className: "form_control flex-wrap d-sm-flex py-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
        lg: 6,
        md: 12,
        className: "pe-lg-2 pe-0",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Label, {
          children: "Your Name*"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Control, _objectSpread(_objectSpread({
          className: "input_item is-invalid",
          type: "text"
        }, register("name")), {}, {
          style: {
            border: (_errors$name = errors.name) !== null && _errors$name !== void 0 && _errors$name.message ? "1px solid #dc3545" : "none"
          }
        })), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
          className: "invalid-feedback f-12",
          children: (_errors$name2 = errors.name) === null || _errors$name2 === void 0 ? void 0 : _errors$name2.message
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
        lg: 6,
        md: 12,
        className: "ps-lg-2 ps-0",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Label, {
          children: "Your Email*"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Control, _objectSpread({
          className: "input_item is-invalid",
          type: "email",
          style: {
            border: (_errors$email = errors.email) !== null && _errors$email !== void 0 && _errors$email.message ? "1px solid #dc3545" : "none"
          }
        }, register("email"))), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
          className: "invalid-feedback f-12",
          children: (_errors$email2 = errors.email) === null || _errors$email2 === void 0 ? void 0 : _errors$email2.message
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
        lg: 6,
        md: 12,
        className: "pe-lg-2 pe-0",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Label, {
          children: "Your Company*"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Control, _objectSpread(_objectSpread({
          className: "input_item is-invalid",
          type: "text"
        }, register("company_name")), {}, {
          style: {
            border: (_errors$company_name = errors.company_name) !== null && _errors$company_name !== void 0 && _errors$company_name.message ? "1px solid #dc3545" : "none"
          }
        })), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
          className: "invalid-feedback f-12",
          children: (_errors$company_name2 = errors.company_name) === null || _errors$company_name2 === void 0 ? void 0 : _errors$company_name2.message
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
        lg: 6,
        md: 12,
        className: "ps-lg-2 ps-0",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Label, {
          children: "Your Phone"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Control, _objectSpread({
          className: "input_item",
          type: "text"
        }, register("phone")))]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Group, {
      className: "form_control mb-4",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Label, {
        children: "Leave a Reply"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Form.Control, _objectSpread({
        className: "text_area_section",
        as: "textarea",
        rows: 6
      }, register("message")))]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("button", {
      className: "btnStyle d-block d-lg-inline-block",
      type: "submit",
      children: [loading && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("span", {
        className: "spinner-border spinner-border-sm",
        role: "status",
        "aria-hidden": "true",
        style: {
          marginRight: "5px"
        }
      }), "Send Message"]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PortfolioContactForm);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9026:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(358);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_hi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1111);
/* harmony import */ var react_icons_hi__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_hi__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _common_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4000);
/* harmony import */ var _components_PortfolioContactForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(769);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1664);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_components_PortfolioContactForm__WEBPACK_IMPORTED_MODULE_4__]);
_components_PortfolioContactForm__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









function PortfolioSingle({
  locale,
  portfolio
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
      className: "top_content px-3 px-md-2 px-xl-0",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
          lg: 6,
          className: "left_section order-2 order-lg-1 single_portfolio_left",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("p", {
            className: "date_info",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("strong", {
              children: (0,_common_helpers__WEBPACK_IMPORTED_MODULE_3__/* .translateText */ .O9)(locale, portfolio, "subtitle")
            }), " "]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h2", {
            className: "h_title",
            children: (0,_common_helpers__WEBPACK_IMPORTED_MODULE_3__/* .translateText */ .O9)(locale, portfolio)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            dangerouslySetInnerHTML: {
              __html: (0,_common_helpers__WEBPACK_IMPORTED_MODULE_3__/* .translateText */ .O9)(locale, portfolio, "content")
            }
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
          lg: 6,
          className: " order-1 order-lg-2 mb-5",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("img", {
            className: "img_fit",
            src: portfolio.image,
            alt: ""
          })
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
      fluid: true,
      className: "got_project py-4 py-lg-5 px-3 px-md-4",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
            className: "px-0",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "d-md-flex justify-content-between align-items-center pb-4 pb-sm-0",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "pb-4",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("p", {
                  className: "sub_title",
                  children: "LET\u2019S COLLABORATE"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h2", {
                  className: "h_title",
                  children: "Got a project?"
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(next_link__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  href: "/contact-us",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("a", {
                    className: "btnStyle",
                    children: ["Contact Us", /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
                      className: "btnArrow",
                      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_hi__WEBPACK_IMPORTED_MODULE_2__.HiArrowRight, {})
                    })]
                  })
                })
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("hr", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("p", {
              className: "descriptin pt-3",
              children: ["We\u2019re ", /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("strong", {
                children: "a team of creatives"
              }), " who are excited about unique ideas and help fin-tech companies to", " ", /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("strong", {
                children: "create amazing identity"
              }), " by crafting top-notch UI/UX."]
            })]
          })
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
      fluid: true,
      className: "next_project_btn_section d-lg-none px-2 py-4",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Row, {
          className: "px-0",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
            className: "d-flex justify-content-between align-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("p", {
                className: "s_title",
                children: "Next Project"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h4", {
                className: "s_h_title",
                children: "Robi Website"
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "next_preview_btn",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "d-flex btn_position",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("button", {
                  className: "circle",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_hi__WEBPACK_IMPORTED_MODULE_2__.HiArrowLeft, {})
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("button", {
                  className: "circle",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_hi__WEBPACK_IMPORTED_MODULE_2__.HiArrowRight, {})
                  })
                })]
              })
            })]
          })
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
      fluid: true,
      className: "post_comment pt-5 pt-lg-0  pb-5",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Container, {
        className: "px-0 single_portfolio_contact",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_1__.Col, {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h4", {
              className: "s_h_title",
              children: "Send a message"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("p", {
              children: "Your email address will not be published. Required fields are marked *"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_PortfolioContactForm__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {})]
          })
        })
      })
    })]
  });
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PortfolioSingle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;