import { string } from "yup/lib/locale";

export interface TestimonialTypes {
  data: [
    {
      description: string;
      name: string;
      company: string;
      image: string;
    }
  ];
}
export interface PaginateProps {
  total: number;
  postPerPage: number;
  paginate: (val: number) => void;
}

export interface PortfolioDataTypes {
  id: number;
  title: string;
  image: string;
  category: string;
  featured: boolean;
  keywords: string[];
  client: string;
  year: string;
  description: string;
  content: string;
  gallery: string[];
  embedCode: string;
  created_at: string;
  updated_at: string;
}

export interface CommonPageData {
  page: {
    banner: any;
    banner_sd: any;
    breadcrumb: any;
    content_bn: string;
    content_en: string;
    excerpt_bn: string;
    excerpt_en: string;
    items: any;
    meta: {
      title_bn: string;
      title_en: string;
      content_bn: string;
      content_en: string;
      script_en: any;
      script_bn: any;
    };
    slider: any;
    slug: string;
    subtitle_bn: string;
    subtitle_en: string;
    template_name: string;
    terms_bn: any;
    terms_en: any;
    thumb: string;
    thumb_sd: string;
    title_bn: string;
    title_en: string;
  };
  locale: string | undefined;
}

export interface TopBannerProps {
  slider: [
    {
      title_en: string;
      title_bn: string;
      sub_title_en: string;
      sub_title_bn: string;
      action_title_en: string;
      action_title_bn: string;
      action_url: string;
      meta: any;
    }
  ];
  locale: string | undefined;
}

export interface ServiceProps {
  service: {
    title_en: string;
    title_bn: string;
    content_en: string;
    content_bn: string;
    items: [];
  };
  locale: string | undefined;
}

export interface CapabilitiesProps {
  capabilities: {
    skills: any;
    faqs: any;
    stats: any;
    title_en: string;
    title_bn: string;
    content_en: string;
    content_bn: string;
  };
  locale: string | undefined;
}

export interface TestimonialProps {
  testimonial: {
    items: any;
  };
  locale: string | undefined;
}

export interface PortfolioProps {
  portfolio: [];
  locale: string | undefined;
}

export interface PortfolioDataTypes {
  title_en: string;
  title_bn: string;
  subtitle_en: string;
  subtitle_bn: string;
  description_en: string;
  description_bn: string;
  image: string;
  url: any;
  url_text: string;
  slug: string;
  date: any;
}

export interface ProjectModalProps {
  project: PortfolioDataTypes;
  handleClose: () => void;
  locale: string | undefined;
}

export interface ServicePageSectionProps {
  service: [
    {
      title_en: string;
      title_bn: string;
      description_en: string;
      description_bn: string;
      content_en: string;
      content_bn: string;
      keywords_en: any;
      keywords_bn: any;
      category: any;
      icon: any;
    }
  ];
  locale: string | undefined;
  pageTitle: string;
  breadcrumb: [
    {
      title_en: string;
      title_bn: string;
      slug: string;
      template_name: string;
    }
  ];
}

export interface BreadCrumbProps {
  breadcrumb: [
    {
      title_en: string;
      title_bn: string;
      slug: string;
      template_name: string;
    }
  ];
  locale: string | undefined;
}

export interface ContactDataTypes {
  name: string;
  company: string;
  email: string;
  phone: string;
  message: string;
}
