import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import aboutUsOne from "../asset/images/Softwind-Tech-Employee_1.jpg";
import aboutUsTwo from "../asset/images/Softwind-Tech-Employee_2.jpg";
import { IoKeypad } from "react-icons/io5";
import { translateText } from "./../common/helpers";
import Link from "next/link";
import Fade from "react-reveal/Fade";

function AboutSWT({ service, locale }) {
  if (!service) {
    return null;
  }
  return (
    <Container className="about_swt_inner px-3">
      <Row>
        <Col lg={4} md={5} className="left_section px-1 mb-5">
          <Fade bottom duration={1000}>
            <p className="sub_title">Stay ahead of your time</p>
            <h2 className="title">{translateText(locale, service)}</h2>
          </Fade>
        </Col>

        <Col lg={8} md={7} className="px-3">
          <Row className="d-flex flex-wrap">
            {service.items.map((singleService, idx) => {
              return (
                <Col
                  md={6}
                  className="right_section px-3 px-lg-5 mb-5"
                  key={singleService.slug}
                >
                  <div className="right_section_inner">
                    <Fade bottom duration={1000}>
                      <p className="sub_title">0{idx + 1}.</p>
                      <h2 className="title">
                        <Link
                          href={`/individuals/service/${singleService.slug}`}
                        >
                          <a className="link_unset">
                            {translateText(locale, singleService) ||
                              "Untitled Service"}
                          </a>
                        </Link>
                      </h2>
                      <p className="description">
                        {translateText(locale, singleService, "description")}
                      </p>
                    </Fade>
                  </div>
                </Col>
              );
            })}
          </Row>
        </Col>
      </Row>
    </Container>
  );
}

export default AboutSWT;
