import SingleCapability from "./SingleCapability";
import React, { Fragment } from "react";
import { Col, Container, Row, ProgressBar } from "react-bootstrap";
import { AiOutlinePlus, AiOutlineMinus } from "react-icons/ai";
import { IoKeypad } from "react-icons/io5";
import { translateText } from "../common/helpers";
import { CapabilitiesProps } from "../common/interfaces";
import CountUp from "react-countup";
import VisibilitySensor from "react-visibility-sensor";

const CapabilitiesSection: React.FC<CapabilitiesProps> = ({
  capabilities,
  locale,
}) => {
  return (
    <Fragment>
      <Container
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <div className="capabilitie_section px-2 px-sm-0">
          <Row>
            <Col md={6}>
              <div className="left_section">
                <p className="sub_title">
                  {translateText(locale, capabilities)}
                </p>
                <h2 className="title d-none d-lg-block">
                  {translateText(locale, capabilities, "content")}
                </h2>
                <h2 className="title d-block d-lg-none ">
                  {translateText(locale, capabilities, "content")}
                </h2>

                <div className="skills_bar">
                  {capabilities.skills &&
                    capabilities.skills.length > 0 &&
                    capabilities.skills.map(
                      (
                        capability: {
                          name: string | undefined;
                          value: number | null;
                        },
                        index: any
                      ) => {
                        return (
                          <SingleCapability
                            capability={capability}
                            key={index}
                          />
                        );
                      }
                    )}
                </div>
              </div>
            </Col>
            <Col md={6}>
              <div className="according">
                {capabilities.faqs.items.length > 0 &&
                  capabilities.faqs.items.map(
                    (
                      faq: {
                        question_en: string;
                        question_bn: string;
                        answer_en: string;
                        answer_bn: string;
                      },
                      index: any
                    ) => {
                      return (
                        <div className="according-tab" key={index}>
                          <input
                            type="checkbox"
                            id={index}
                            className="according-toggle"
                            name="toggle"
                          />
                          <label htmlFor={index}>
                            <span>
                              <AiOutlinePlus className="plus icon_color" />
                            </span>
                            <div className="minus">
                              <AiOutlineMinus className="icon_color" />
                            </div>
                            {translateText(locale, faq, "question")}
                          </label>
                          <div className="according-content">
                            <p className="para1">
                              {translateText(locale, faq, "answer")}
                            </p>
                          </div>
                        </div>
                      );
                    }
                  )}
              </div>
            </Col>
          </Row>
          <Row className="countdown_section text-center text-sm-start mt-3 mt-sm-5">
            {capabilities.stats.length > 0 &&
              capabilities.stats.map(
                (
                  stat: {
                    title_en: string;
                    title_bn: string;
                    content_en: string;
                    content_bn: string;
                    count: string;
                  },
                  index: any
                ) => {
                  return (
                    <Col lg={3} md={6} sm={6} key={index}>
                      <span>
                        <IoKeypad className="keypad_icon" />
                      </span>
                      <span className="count_number">
                        <VisibilitySensor partialVisibility>
                          {() => (
                            <>
                              <CountUp
                                end={parseInt(stat.count)}
                                duration={4}
                                useEasing={false}
                              />
                            </>
                          )}
                        </VisibilitySensor>
                      </span>
                      <h6 className="heading">{translateText(locale, stat)}</h6>
                      <p className="info">
                        {translateText(locale, stat, "content")}
                      </p>
                    </Col>
                  );
                }
              )}
          </Row>
        </div>
      </Container>
    </Fragment>
  );
};

export default CapabilitiesSection;
