import React, { useEffect, Fragment } from "react";
import { Col, Container, Row, Button } from "react-bootstrap";
import { MdOutlineError } from "react-icons/md";
import Link from "next/link";
class ErrorBoundary extends React.Component {
  constructor(props) {
    super(props);

    // Define a state variable to track whether is an error or not
    this.state = { hasError: false };
  }
  static getDerivedStateFromError(error) {
    // Update state so the next render will show the fallback UI

    return { hasError: true };
  }
  componentDidCatch(error, errorInfo) {
    // You can use your own error logging service here
  }
  render() {
    // Check if the error is thrown
    if (this.state.hasError) {
      // You can render any custom fallback UI
      return (
        <Fragment>
          <Container className="error_section flex_center text-center section_margin">
            <Row>
              <Col>
                <h1 className="title">
                  ERR
                  <span>
                    <MdOutlineError />
                  </span>
                  R
                </h1>
                <h2 className="sub_title">Oops, there is an error!</h2>
                <p>
                  Please reload and try again, <Link href="/">Contact Us</Link>{" "}
                  If the problem persists.
                </p>
                <Link href="/">
                  <Button className="btnStyle">Go back to home</Button>
                </Link>
              </Col>
            </Row>
          </Container>
        </Fragment>
      );
    }

    // Return children components in case of no error

    return this.props.children;
  }
}

export default ErrorBoundary;
