import React, { Fragment, useEffect, useState } from "react";
import { Col, Container, Row, Button } from "react-bootstrap";
import swtLogoWhite from "../asset/images/Swt_logo_white.png";
import { useUiState } from "../common/contexts/UiContextProvider";
import { useTheme } from "next-themes";
import Link from "next/link";
import { useRouter } from "next/router";
import { translateText } from "./../common/helpers";
import { NavLink } from "./NavLink";
import { FaFacebookF, FaYoutube } from "react-icons/fa";

function Footer(props) {
  const [UiState, setUiState] = useUiState();
  const { setting } = UiState;
  const { theme, setTheme } = useTheme();
  const router = useRouter();
  const { locale } = router;
  const [menus, setMenus] = useState([]);

  useEffect(() => {
    setMenus(UiState.setting.menus.footer || []);
    return () => {};
  }, [UiState]);

  const openSocialPage = (social) => {
    if (social === "fb") {
      window.open("https://www.facebook.com/SoftWindTech/");
    } else {
      window.open("https://www.youtube.com/user/SoftwindTech");
    }
  };

  return (
    <Fragment>
      <Container
        fluid={true}
        className="footer_section pt-3"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
      >
        <Container className="px-2 px-lg-4">
          <Row className="footer_inner py-5">
            <Col sm={6} lg={6} xl={3} className="mb-5 mb-sm-3">
              <div>
                {theme == "light" || !theme ? (
                  <img
                    src={UiState.setting.site_logo_light || swtLogoWhite.src}
                  />
                ) : (
                  <img src={UiState.setting.site_logo || swtLogoWhite.src} />
                )}
              </div>
            </Col>
            <Col sm={6} lg={6} xl={3} className="mb-sm-3">
              <div>
                <p className="title">Address</p>
                <address
                  dangerouslySetInnerHTML={{
                    __html: setting.address,
                  }}
                ></address>
              </div>
            </Col>
            <Col sm={6} lg={6} xl={3} className="mb-sm-3">
              <div>
                <p className="title">Email</p>
                <address>{setting.contact_email}</address>
                <p className="title">Phone</p>
                <address>{setting.contact_phone}</address>
              </div>
            </Col>
            <Col sm={6} lg={6} xl={3} className="mb-sm-3">
              <div>
                <p className="title">Navigate</p>
                <ul className="p-0">
                  {menus.map((menuItem, idx) => {
                    return (
                      <li key={idx}>
                        <NavLink to={menuItem.slug} className="link_unset">
                          {translateText(locale, menuItem)}
                        </NavLink>
                      </li>
                    );
                  })}
                </ul>
                {/* <ul>
                  <li>Contact us</li>
                </ul> */}
                {/* <input type="email" placeholder="Your email address" />
                <a href="#" className="btnStyle subscribeBtn">
                  Subscribe
                </a> */}
                <div className="footer_social">
                  <div className="d-inline-flex mt-4">
                    <Button
                      className="footer_social_btn"
                      onClick={() => openSocialPage("fb")}
                    >
                      <FaFacebookF className="facebook_icon" />
                    </Button>
                    <Button
                      className="footer_social_btn mx-2"
                      onClick={() => openSocialPage("youtube")}
                    >
                      <FaYoutube className="youtube_icon" />
                    </Button>
                  </div>
                </div>
              </div>
            </Col>
          </Row>
          <Row>
            <Col className="copyright_section d-flex justify-content-between align-items-center py-2 py-sm-4 flex-column flex-sm-row">
              <div>
                © {new Date().getFullYear()} {setting.site_name}
              </div>
              <div>All right reserved.</div>
            </Col>
          </Row>
        </Container>
      </Container>
    </Fragment>
  );
}

export default Footer;
