import React, { Fragment, useEffect, useState } from "react";
import { Container, Button, Row, Col, Nav, Navbar } from "react-bootstrap";
import { NavLink } from "./NavLink";
import { AiOutlineClose, AiFillYoutube } from "react-icons/ai";
import { FaFacebookF, FaYoutube } from "react-icons/fa";
import { FiMinus } from "react-icons/fi";
import { IoAddOutline } from "react-icons/io5";
import { useUiState } from "../common/contexts/UiContextProvider";
import { translateText } from "../common/helpers";
import NavItemMobile from "./NavItemMobile";

function HamburgerMenu(props) {
  const { locale } = props;
  const [menus, setMenus] = useState([]);
  const [UiState, setUiState] = useUiState();
  const { setting } = UiState;
  useEffect(() => {
    setMenus(UiState.setting.menus.mobile);
    return () => {};
  }, [UiState]);

  const openSocialPage = (social) => {
    if (social === "fb") {
      window.open("https://www.facebook.com/SoftWindTech/");
    } else {
      window.open("https://www.youtube.com/user/SoftwindTech");
    }
  };
  return (
    <Fragment>
      <Container
        fluid={true}
        className="hamburger_menu d-none d-md-flex justify-content-between flex-column"
      >
        {/* ------------ Hamburger Menu Start ------- */}
        <Nav className="d-flex flex-column">
          <button
            type="button"
            onClick={props.handleClose}
            className="close_btn "
          >
            <AiOutlineClose className="close_btn_icon" />
          </button>

          {menus.map((item, idx) => {
            return (
              <NavItemMobile
                type="hamburger"
                locale={locale}
                menuItem={item}
                key={item.slug}
                serial={idx + 1}
              />
            );
          })}
        </Nav>
        {/* ------------ Hamburger Menu End ------- */}

        <div className="footer_text d-flex flex-column mx-3">
          <div className="d-flex">
            <div className="pe-5">
              <p className="title">Get In Touch</p>
              <li>{setting.address}</li>
            </div>
            <div>
              <p className="title">Work Inquiries</p>
              <li>{setting.contact_email}</li>
              <li>Phone: {setting.contact_phone}</li>
            </div>
          </div>
          <div className="d-inline-flex mt-4">
            <Button className="social_btn" onClick={() => openSocialPage("fb")}>
              <FaFacebookF className="facebook_icon" />
            </Button>
            <Button
              className="social_btn mx-2"
              onClick={() => openSocialPage("youtube")}
            >
              <FaYoutube className="youtube_icon" />
            </Button>
          </div>
        </div>
      </Container>
      <Container fluid={true} className="hamburger_menu  d-flex d-md-none ">
        {/* ------------ Mobile Menu Start ------- */}

        <Nav className="mobile_menu d-flex flex-column p-3">
          <button
            type="button"
            onClick={props.handleClose}
            className="close_btn "
          >
            <AiOutlineClose className="close_btn_icon" />
          </button>

          {/* --------- Mobile Dropdown Menu Start ---------- */}
          {menus.map((item, idx) => {
            return (
              <NavItemMobile
                type="mobile"
                locale={locale}
                menuItem={item}
                key={item.slug}
                serial={idx + 1}
              />
            );
          })}

          {/* --------- Dropdown Menu End ---------- */}
          <div className="copyright_section">
            <li className="pb-1">
              © {new Date().getFullYear()} Softwindtech Ltd.
            </li>
            <li>All right reserved.</li>
          </div>
        </Nav>

        {/* ------------ Mobile Menu End ------- */}
        <div className="social_section flex_center">
          <div className="follow_us">
            <p>
              Follow Us
              <span className="minus">
                <FiMinus className="minus_btn" />
              </span>
            </p>
            <div className="social_icon">
              <a href="https://www.youtube.com/user/SoftwindTech">
                {" "}
                <AiFillYoutube />
              </a>
              <a href="https://www.facebook.com/SoftWindTech/">
                <FaFacebookF />
              </a>
            </div>
          </div>
        </div>
      </Container>
    </Fragment>
  );
}

export default HamburgerMenu;
