import React, { Fragment } from "react";
import TopNavigation from "./TopNavigation";
import Footer from "./Footer";
import OverlayContentLeft from "./OverlayContentLeft";
import OverlayContentRight from "./OverlayContentRight";
import HamburgerMenu from "./HamburgerMenu";
import ErrorBoundary from "./ErrorBoundary";
import ErrorFallback from "./ErrorFallback";

function Layout(props) {
  return (
    <Fragment>
      <TopNavigation title="Home" />
      <div className="d-none d-lg-inline-block">
        {typeof window !== "undefined" && (
          <>
            <OverlayContentLeft />
            <OverlayContentRight />
          </>
        )}
      </div>
      <ErrorBoundary FallbackComponent={ErrorFallback}>
        {props.children}
      </ErrorBoundary>
      <Footer />
    </Fragment>
  );
}

export default Layout;
