import React from "react";
import { NavLink } from "./NavLink";
import { translateText } from "./../common/helpers";
import { NavDropdown } from "react-bootstrap";
import { IoAddOutline } from "react-icons/io5";
const NavItemMobile = ({ type, locale, menuItem, serial, sub = false }) => {
  const { slug, children } = menuItem;
  return children.length > 0 ? (
    <NavLink
      exact
      to={menuItem.slug}
      className={`${
        type == "mobile" ? "navItem2 nav_dropdown_mb" : "navItem2 nav_dropdown"
      }`}
    >
      {translateText(locale, menuItem)}
      <span className="number_text">0{serial}</span>
      <span className="add_icon">
        <IoAddOutline />
      </span>
      <div
        className={`dropdown_section ${
          sub ? "sub_dropdown_menu" : "dropdown_menu"
        }`}
      >
        {children.map((childMenuItem, idx) => {
          return (
            <NavItemMobile
              locale={locale}
              menuItem={childMenuItem}
              key={childMenuItem.slug}
              serial={idx + 1}
              sub={true}
            />
          );
        })}
      </div>
    </NavLink>
  ) : (
    <NavLink
      exact
      className={`${
        sub
          ? "dropdown_item"
          : type == "mobile"
          ? "nav_dropdown nav_dropdown_mb"
          : "navmItem2 nav_dropdown nav_dropdown_mb"
      }`}
      to={menuItem.slug}
    >
      {translateText(locale, menuItem)}
      <span className="number_text">0{serial}</span>
    </NavLink>
  );
};

export default NavItemMobile;
