import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { GoSearch } from "react-icons/go";
import Fade from "react-reveal/Fade";

function PageTop(props) {
  return (
    <Fragment>
      <Container
        className="page_top px-3 section_margin"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Row>
          <Col>
            <div className="page_top_inner py-3 py-xl-4">
              <Fade bottom duration={1000}>
                <p className="sub_title">{props.subTitle}</p>
                <h2 className="title pb-4 pb-lg-5">{props.title}</h2>
              </Fade>
            </div>
          </Col>
        </Row>
      </Container>
    </Fragment>
  );
}

export default PageTop;
