import Link from "next/link";
import React, { useState } from "react";
import { Nav } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import { PaginateProps } from "../common/interfaces";

const Paginate: React.FC<PaginateProps> = ({
  total,
  postPerPage,
  paginate,
}) => {
  const [status, setStatus] = useState(1); // checking status of current page number on click
  const pageNumbers = [];

  for (let i = 1; i <= Math.ceil(total / postPerPage); i++) {
    pageNumbers.push(i);
  }

  return (
    <Nav className="portfolio_pagination">
      <ul className="pagination">
        {status > 1 && (
          <li className="page-item">
            <a
              onClick={() => {
                paginate(status - 1);
                setStatus(status - 1);
              }}
              className="page-link bg-transparent"
            >
              <span>
                <HiArrowLeft />
              </span>{" "}
              Prev
            </a>
          </li>
        )}
        {pageNumbers.map((number) => (
          <li className="page-item " key={number}>
            <a
              onClick={() => {
                paginate(number);
                setStatus(number);
              }}
              className={
                status === number
                  ? "active_page page-link bg-transparent"
                  : " page-link bg-transparent"
              }
            >
              {number}
            </a>
          </li>
        ))}

        {status < pageNumbers.length && (
          <li className="page-item">
            <a
              onClick={() => {
                paginate(status + 1);
                setStatus(status + 1);
              }}
              className="page-link bg-transparent"
            >
              Next{" "}
              <span>
                <HiArrowRight />
              </span>
            </a>
          </li>
        )}
      </ul>
    </Nav>
  );
};

export default Paginate;
