import React, { Fragment, useState } from "react";
import { Container } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import { FaExpand } from "react-icons/fa";
import ProjectModalView from "./ProjectModalView";
import Paginate from "./Paginate";
import { PortfolioProps, PortfolioDataTypes } from "../common/interfaces";
import { translateText } from "../common/helpers";
import { translate } from "./../common/helpers";
import Link from "next/link";
import BackButton from "./BackButton";

const PortfolioSection: React.FC<PortfolioProps> = ({
  portfolio,
  page,
  locale,
}) => {
  const [openDetailsPopup, setOpenDetailsPopup] = useState({
    open: false,
    data: {},
  });

  const [currentPage, setCurrentPage] = useState(1);
  const [postPerPage] = useState(7);

  const closeDetailsPopup = () =>
    setOpenDetailsPopup({
      open: false,
      data: {},
    });

  const indexOfLastPortfolio = currentPage * postPerPage;
  const indexOfFirstPortfolio = indexOfLastPortfolio - postPerPage;
  const currentPortfolio: PortfolioDataTypes[] = portfolio.slice(
    indexOfFirstPortfolio,
    indexOfLastPortfolio
  );

  const paginate = (pageNumber: number) => setCurrentPage(pageNumber);

  return (
    <Fragment>
      {openDetailsPopup.open ? (
        <ProjectModalView
          project={openDetailsPopup.data}
          handleClose={closeDetailsPopup}
          locale={locale}
        />
      ) : null}
      <Container
        className="portfolio_section section_margin px-3 px-xl-4"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <BackButton />
        <div className="my-3 my-lg-5 top_section">
          <h2 className="h_title">{translateText(locale, page)}</h2>

          <p className="pb-0 pb-sm-3 section_sub">
            {translateText(locale, page, "excerpt")}
          </p>
          <Link href="/contact-us">
            <a className="btnStyle d-none d-sm-inline-block">
              {translate(locale, "portfolio.cta")}
              <span className="btnArrow">
                <HiArrowRight />
              </span>
            </a>
          </Link>
          <Link href="/contact-us">
            <a className="btnStyle_sm d-sm-none">
              {translate(locale, "portfolio.cta")}
              <span className="btnArrow">
                <HiArrowRight />
              </span>
            </a>
          </Link>
        </div>
        <div className="portfolio_gallery">
          <div className="gallery">
            {currentPortfolio &&
              currentPortfolio.map((singlePortfolio, idx) => {
                return (
                  <div key={idx} className="box pb-3">
                    <div
                      className=""
                      onClick={() => {
                        setOpenDetailsPopup({
                          open: true,
                          data: singlePortfolio,
                        });
                      }}
                    >
                      <img
                        className="img_fit"
                        src={singlePortfolio.image}
                        alt=""
                      />
                      {/*  <!-- Button trigger modal --> */}
                      <button
                        type="button"
                        className="img_expand_icon flex_center"
                      >
                        <FaExpand />
                      </button>
                    </div>

                    <div className="info py-3 px-2">
                      <h5 className="s_h_title">
                        {translateText(locale, singlePortfolio)}
                      </h5>
                      <h6 className="sub_title">
                        <span className="identity">
                          {singlePortfolio.url_text}
                        </span>
                        <Link
                          href={`/individuals/portfolio/${singlePortfolio.slug}`}
                        >
                          <a className="show_project">
                            {translate(locale, "portfolio.viewButton")}
                          </a>
                        </Link>
                      </h6>
                    </div>
                  </div>
                );
              })}
          </div>
          {/* ---------- Pagination Section ------- */}
          {portfolio.length > postPerPage && (
            <Paginate
              total={portfolio.length}
              postPerPage={postPerPage}
              paginate={paginate}
            />
          )}
        </div>
      </Container>
    </Fragment>
  );
};

export default PortfolioSection;
