import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import robiSide from "../asset/images/robi-side.png";
import { AiOutlineClose } from "react-icons/ai";
import { HiArrowRight } from "react-icons/hi";
import { ProjectModalProps } from "../common/interfaces";
import { translateText } from "../common/helpers";
import Link from "next/link";
import { translate } from "./../common/helpers";

const ProjectModalView: React.FC<ProjectModalProps> = ({
  project,
  handleClose,
  locale,
}) => {
  return (
    <Fragment>
      <Container fluid={true} className="project_modal_view d-lg-flex p-0 m-0">
        <button
          type="button"
          onClick={handleClose}
          className="close_btn t_r_btn "
        >
          <AiOutlineClose className="icon" />
        </button>
        <div className="img_section">
          <img className="img_fit" src={project.image} alt="" />
        </div>
        <div className="content_section">
          <div className="content_section_inner">
            <p className="date_info">
              {translateText(locale, project, "subtitle")} <span>.</span>
              {project.date}
            </p>
            <h2 className="h_title">{translateText(locale, project)}</h2>
            <p className="description">
              {translateText(locale, project, "description")}
            </p>
            <Link href={`/individuals/portfolio/${project.slug}`}>
              <a className="btnStyle p-0">
                {translate(locale, "portfolio.viewButton")}
                <span className="btnArrow">
                  <HiArrowRight />
                </span>
              </a>
            </Link>
          </div>
        </div>
      </Container>
    </Fragment>
  );
};

export default ProjectModalView;
