import React, { Fragment } from "react";
import { Container, Nav } from "react-bootstrap";
import { NavLink } from "./NavLink";
import { RiPencilRulerLine } from "react-icons/ri";
import { BsCheck2, BsWindow } from "react-icons/bs";
import { HiArrowLeft } from "react-icons/hi";
import { ServicePageSectionProps } from "../common/interfaces";
import { translateText } from "../common/helpers";
import BreadCrumb from "./BreadCrumb";

const ServicePageSection: React.FC<ServicePageSectionProps> = ({
  service,
  locale,
  pageTitle,
  breadcrumb,
}) => {
  return (
    <Fragment>
      <Container className="service_page_section section_margin px-3 px-xl-4">
        <button className="btn_c btn_back">
          <span>
            <HiArrowLeft />
          </span>
          <span className="btn_text">Back</span>
        </button>
        <div className="my-3 my-lg-5 section_title">
          <h2 className="h_title">{pageTitle}</h2>
        </div>
        <BreadCrumb breadcrumb={breadcrumb} locale={locale} />
        <div className="service_card d-flex justify-content-center flex-wrap my-4 my-lg-5">
          {/* --------- card-1--------- */}
          {service.length > 0 &&
            service.map((singleService, index) => {
              return (
                <div className="card">
                  <div className="card-img-top">
                    <RiPencilRulerLine />
                  </div>
                  <div className="card-body">
                    <h4 className="card-title">
                      {translateText(locale, singleService)}
                    </h4>
                    <p className="card-text mb-0">
                      {translateText(locale, singleService, "description")}
                    </p>
                    <ul className="single_service_ul">
                      {locale === "en"
                        ? singleService.keywords_en.length > 0 &&
                          singleService.keywords_en.map(
                            (keyword: string, i: number) => (
                              <>
                                <li>
                                  <span>
                                    <BsCheck2 />
                                  </span>
                                  {keyword}{" "}
                                </li>
                              </>
                            )
                          )
                        : singleService.keywords_bn.length > 0 &&
                          singleService.keywords_bn.map(
                            (keyword: string, i: number) => (
                              <>
                                <li>
                                  <span>
                                    <BsCheck2 />
                                  </span>
                                  {keyword}{" "}
                                </li>
                              </>
                            )
                          )}
                    </ul>
                    <NavLink to="/single-service" className="btnStyle">
                      Read More
                    </NavLink>
                  </div>
                </div>
              );
            })}
        </div>
      </Container>
    </Fragment>
  );
};

export default ServicePageSection;
