import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import Link from "next/link";
import Fade from "react-reveal/Fade";

function ShowcaseSection(props) {
  return (
    <Fragment>
      <Container
        fluid={true}
        className="showcase_section"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_white"}'
      >
        <Row>
          <Col md={6} sm={12} className="capabilities">
            <Fade bottom duration={1000}>
              <div className="cap_des">
                <p
                  className="sub_title"
                  style={{ color: "rgba(249, 249, 249, 0.7)" }}
                >
                  CAPABILITIES
                </p>
                <h2 className="title d-none d-md-block">
                  Services <br /> we provide to your business needs, Let's have
                  a look.
                </h2>
                <h2 className="title d-md-none">
                  Services we provide to your business needs, Let's have a look.
                </h2>
                <Link href={"/services"}>
                  <a className="btnStyle d-none d-sm-inline-block">
                    View Services
                    <span className="btnArrow">
                      <HiArrowRight />
                    </span>
                  </a>
                </Link>
                <Link href={"/services"}>
                  <a className="btnStyle_sm d-inline-block d-sm-none">
                    View Services
                    <span className="btnArrow">
                      <HiArrowRight />
                    </span>
                  </a>
                </Link>
              </div>
            </Fade>
          </Col>
          <Col md={6} sm={12} className="showcase">
            <Fade bottom duration={1000}>
              <div className="cap_des">
                <p
                  className="sub_title"
                  style={{ color: "rgba(249, 249, 249, 0.7)" }}
                >
                  SHOWCASE
                </p>
                <h2 className="title d-none d-lg-block">
                  Look at <br /> our most recent work <br /> in the world of
                  technology.
                </h2>
                <h2 className="title d-lg-none">
                  Look at our most recent work in the world of technology.
                </h2>
                <Link href={"/portfolio"}>
                  <a className="btnStyle d-none d-sm-inline-block">
                    View Projects
                    <span className="btnArrow">
                      <HiArrowRight />
                    </span>
                  </a>
                </Link>
                <Link href={"/portfolio"}>
                  <a className="btnStyle_sm d-inline-block d-sm-none">
                    View Projects
                    <span className="btnArrow">
                      <HiArrowRight />
                    </span>
                  </a>
                </Link>
              </div>
            </Fade>
          </Col>
        </Row>
      </Container>
    </Fragment>
  );
}

export default ShowcaseSection;
