import React, { Fragment } from "react";
import { Container, Row, Col } from "react-bootstrap";
import {
  FaCoffee,
  FaHandHoldingHeart,
  FaAward,
  FaBriefcase,
} from "react-icons/fa";
import { translateText } from "../common/helpers";
import Fade from "react-reveal/Fade";

function SummarySection({ campaign, locale }) {
  if (!campaign) {
    return null;
  }
  return (
    <Fragment>
      <Container
        fluid={true}
        className="summary_section"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Container>
          <Row>
            <Col lg={7} className="left_section text-center mb-3 mb-sm-5 ">
              <Fade bottom duration={1000}>
                <Row
                  className="d-flex flex-wrap"
                  dangerouslySetInnerHTML={{
                    __html: translateText(locale, campaign, "content"),
                  }}
                />
              </Fade>
            </Col>
            <Col lg={5} className="right_section">
              <Fade bottom duration={1000}>
                <h2 className="h_title">
                  {translateText(locale, campaign, "subtitle")}
                </h2>
                <p className="mt-4">
                  {translateText(locale, campaign, "excerpt")}
                </p>
              </Fade>
            </Col>
          </Row>
        </Container>
      </Container>
    </Fragment>
  );
}

export default SummarySection;
