import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { TestimonialProps } from "../common/interfaces";
import TestimonialSlider from "./TestimonialSlider";

const Testimonials: React.FC<TestimonialProps> = ({ testimonial, locale }) => {
  return (
    <Fragment>
      <Container
        fluid={true}
        className="testimonials"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <Row>
          <Col lg={7} className="client_review">
            <Container>
              <Row className="d-flex justify-content-start justify-content-sm-center align-items-center">
                <Col xl={9} className="testimonial_header">
                  <p className="sub_title">TESTIMONIALS</p>
                  <h1 className="title pb-3">
                    We help them to achieve their organizational goal
                  </h1>
                </Col>
                <TestimonialSlider data={testimonial.items} locale={locale} />
              </Row>
            </Container>
          </Col>
          <Col lg={5} className="client_review_img p-0"></Col>
        </Row>
      </Container>
    </Fragment>
  );
};

export default Testimonials;
