import { IProjectionNode } from "./types";
export declare const rootProjectionNode: {
    current: IProjectionNode | undefined;
};
export declare const HTMLProjectionNode: {
    new (id: number | undefined, latestValues?: import("../..").ResolvedValues, parent?: IProjectionNode<unknown> | undefined): {
        id: number | undefined;
        instance: HTMLElement;
        root: IProjectionNode<unknown>;
        parent?: IProjectionNode<unknown> | undefined;
        path: IProjectionNode<unknown>[];
        children: Set<IProjectionNode<unknown>>;
        options: import("./types").ProjectionNodeOptions;
        snapshot: import("./types").Snapshot | undefined;
        layout: import("./types").Layout | undefined;
        targetLayout?: import("../..").Box | undefined;
        layoutCorrected: import("../..").Box;
        targetDelta?: import("../..").Delta | undefined;
        target?: import("../..").Box | undefined;
        relativeTarget?: import("../..").Box | undefined;
        relativeTargetOrigin?: import("../..").Box | undefined;
        relativeParent?: IProjectionNode<unknown> | undefined;
        isTreeAnimating: boolean;
        isAnimationBlocked: boolean;
        attemptToResolveRelativeTarget?: boolean | undefined;
        targetWithTransforms?: import("../..").Box | undefined;
        projectionDelta?: import("../..").Delta | undefined;
        projectionDeltaWithTransform?: import("../..").Delta | undefined;
        scroll?: import("../..").Point | undefined;
        isLayoutDirty: boolean;
        updateManuallyBlocked: boolean;
        updateBlockedByResize: boolean;
        isUpdating: boolean;
        isSVG: boolean;
        needsReset: boolean;
        shouldResetTransform: boolean;
        treeScale: import("../..").Point;
        resumeFrom?: IProjectionNode<unknown> | undefined;
        resumingFrom?: IProjectionNode<unknown> | undefined;
        latestValues: import("../..").ResolvedValues;
        eventHandlers: Map<import("./types").LayoutEvents, import("../../utils/subscription-manager").SubscriptionManager<any>>;
        nodes?: import("../..").FlatTree | undefined;
        depth: number;
        projectionTransform: string;
        prevTransformTemplateValue: string | undefined;
        preserveOpacity?: boolean | undefined;
        addEventListener(name: import("./types").LayoutEvents, handler: any): () => void;
        notifyListeners(name: import("./types").LayoutEvents, ...args: any): void;
        hasListeners(name: import("./types").LayoutEvents): boolean;
        potentialNodes: Map<number, IProjectionNode<unknown>>;
        registerPotentialNode(id: number, node: IProjectionNode<unknown>): void;
        mount(instance: HTMLElement, isLayoutDirty?: boolean): void;
        unmount(): void;
        blockUpdate(): void;
        unblockUpdate(): void;
        isUpdateBlocked(): boolean;
        isTreeAnimationBlocked(): boolean;
        startUpdate(): void;
        willUpdate(shouldNotifyListeners?: boolean): void;
        didUpdate(): void;
        clearAllSnapshots(): void;
        scheduleUpdateProjection(): void;
        scheduleCheckAfterUnmount(): void;
        checkUpdateFailed: () => void;
        updateProjection: () => void;
        updateSnapshot(): void;
        updateLayout(): void;
        updateScroll(): void;
        resetTransform(): void;
        measure(): import("../..").Box;
        removeElementScroll(box: import("../..").Box): import("../..").Box;
        applyTransform(box: import("../..").Box, transformOnly?: boolean): import("../..").Box;
        removeTransform(box: import("../..").Box): import("../..").Box;
        setTargetDelta(delta: import("../..").Delta): void;
        setOptions(options: import("./types").ProjectionNodeOptions): void;
        clearMeasurements(): void;
        resolveTargetDelta(): void;
        getClosestProjectingParent(): IProjectionNode<unknown> | undefined;
        hasProjected: boolean;
        calcProjection(): void;
        isVisible: boolean;
        hide(): void;
        show(): void;
        scheduleRender(notifyAll?: boolean): void;
        animationValues?: import("../..").ResolvedValues | undefined;
        pendingAnimation?: import("framesync").Process | undefined;
        currentAnimation?: import("../..").AnimationPlaybackControls | undefined;
        mixTargetDelta: (progress: number) => void;
        animationProgress: number;
        setAnimationOrigin(delta: import("../..").Delta, hasOnlyRelativeTargetChanged?: boolean): void;
        startAnimation(options: import("../..").AnimationOptions<number>): void;
        completeAnimation(): void;
        finishAnimation(): void;
        applyTransformsToTarget(): void;
        sharedNodes: Map<string, import("../shared/stack").NodeStack>;
        registerSharedNode(layoutId: string, node: IProjectionNode<unknown>): void;
        isLead(): boolean;
        getLead(): IProjectionNode<unknown> | any;
        getPrevLead(): IProjectionNode<unknown> | undefined;
        getStack(): import("../shared/stack").NodeStack | undefined;
        promote({ needsReset, transition, preserveFollowOpacity, }?: {
            needsReset?: boolean | undefined;
            transition?: import("../..").Transition | undefined;
            preserveFollowOpacity?: boolean | undefined;
        }): void;
        relegate(): boolean;
        resetRotation(): void;
        getProjectionStyles(styleProp?: import("../..").MotionStyle): import("../..").ResolvedValues;
        clearSnapshot(): void;
        resetTree(): void;
    };
};
