module.exports = {
  'language-code': 'ru',
  'document-title': 'иммёрсер — джаваскрипт библиотека для перекрашивания фиксированных блоков по скроллу',
  'readme-title': 'Библиотека для перекрашивания фиксированных блоков по скроллу',
  immerser: 'иммёрсер',
  'menu-link-reasoning': 'Зачем нужен иммёрсер',
  'menu-link-how-to-use': 'Как пользоваться',
  'menu-link-how-it-works': 'Принцип работы',
  'menu-link-options': 'Настройки',
  'menu-link-recipes': 'Рецепты',
  'language-switcher':
    '<a href="./" class="language__link">english</a><span class="language__link language__link--active">по-русски</span>',
  github: 'гитхаб',
  copyright: '&copy; %%THIS_YEAR%% &mdash; Владимир Лысов, Челябинск, Россия',
  'custom-font-body-classname': 'font-cyrillic',
  'why-immerser-title': 'Зачем нужен иммёрсер?',
  'why-immerser-content': `
<p>
  Иногда дизайнеры создают сложную логику и&nbsp;фиксируют части интерфейса.
  А&nbsp;еще они красят разделы страницы в&nbsp;контрастные цвета. Как с&nbsp;этим справиться?
</p>
<p>
  Вам поможет иммёрсер&nbsp;&mdash; джаваскрипт библиотека для замены фиксированных элементов при прокрутке страницы.
</p>
<p>
  Иммёрсер вычисляет состояния один раз в&nbsp;момент инициализации.
  Затем он&nbsp;следит за&nbsp;позицией скролла и&nbsp;планирует перерисовку документа
  в&nbsp;следующем такте цикла событий через метод requestAnimationFrame.
  Скрипт изменяет свойство transform, это задействует графический ускоритель.
</p>
<p>
  Иммёрсер написан на&nbsp;чистом джаваскрипте. Всего&nbsp;%%BUNDLESIZE%%Кб в&nbsp;сжатии gzip.
</p>
`,

  'terms-title': 'Термины',
  'terms-content': `
<p>
<code class="highlighter" data-highlighter="[data-immerser]">Корневой элемент иммёрсера</code>&nbsp;&mdash; это родительский контейнер для ваших фиксированных <code class="highlighter" data-highlighter="[data-immerser-solid], .emoji">блоков</code>.
Фактически они позиционированы абсолютно внутри фиксированного корневого элемента.
<code class="highlighter" data-highlighter="[data-immerser-layer]">Слои</code>&nbsp;&mdash; это разделы страницы, окрашенные в&nbsp;разные цвета.
Еще вы&nbsp;наверняка захотите добавить <code class="highlighter" data-highlighter="[data-immerser-solid='pager']">навигацию</code> по&nbsp;разделам, выделяющую активный раздел.
</p>
`,

  'install-title': 'Установка',
  'install-npm-label': '<p>Через npm:</p>',
  'install-yarn-label': '<p>Через yarn:</p>',
  'install-browser-label': '<p>Или если вы хотите использовать иммёрсер в браузере как глобальную переменную:</p>',

  'prepare-your-markup-title': 'Подготовьте разметку',
  'prepare-your-markup-content': `
<p>Сначала настройте свой фиксированный контейнер как корневой элемент иммёрсера, добавив атрибут <code>data-immerser</code></p>
<p>Затем расположите в&nbsp;нем абсолютно позиционированные дочерние элементы и&nbsp;добавьте каждому атрибут <code>data-immerser-solid="solid-id"</code> с&nbsp;идентификатором блока.</p>
<p>Добавьте каждому слою атрибут <code>data-immerser-layer</code>. Передайте конфигурацию в&nbsp;виде JSON в&nbsp;каждый слой с&nbsp;помощью атрибута
<code>data-immerser-layer-config='{"solid-id": "classname-modifier"}'</code>.
Также вы&nbsp;можете передать конфигурацию всех слоев массивом в&nbsp;параметре <code>solidClassnameArray</code> настроек.
Конфигурация должна содержать описание классов для блоков, когда они находятся поверх слоя.</p>
<p>Так&nbsp;же вы&nbsp;можете добавить элемент с&nbsp;атрибутом <code>data-immerser-pager</code> для создания навигации.</p>
`,

  'apply-styles-title': 'Примените стили',
  'apply-styles-content': `
<p>
  Добавьте стили цвета текста и&nbsp;фона на&nbsp;ваши блоки и&nbsp;слои с&nbsp;помощью классов, переданных в&nbsp;дата-атрибут или настройки.
  В&nbsp;примере я использую <a href="https://ru.bem.info/methodology/">методологию БЭМ</a>.
</p>
`,
  'dont-import-if-umd-line-1': `Вам не нужно импортировать иммёрсер,`,
  'dont-import-if-umd-line-2': `если вы используете его в браузере как глобальную переменную`,
  'data-attribute-will-override-this-option-line-1': 'будет переопределена настройками,',
  'data-attribute-will-override-this-option-line-2': 'переданными в атрибут data-immerser-layer-config каждого слоя',

  'initialize-immerser-title': 'Инициализируйте иммёрсер',
  'initialize-immerser-content': `<p>Добавьте иммёрсер в&nbsp;код и&nbsp;создайте экземпляр с&nbsp;настройками.</p>`,

  'callback-on-init': 'колбек после инициализации',
  'callback-on-bind': 'колбек после привязки к документу',
  'callback-on-unbind': 'колбек после отвязки от документа',
  'callback-on-destroy': 'колбек после уничтожения',
  'callback-on-active-layer-change': 'колбек после смены активного слоя',

  'how-it-works-title': 'Принцип работы',
  'how-it-works-content': `
<p>Сначала иммёрсер собирает информацию о&nbsp;слоях, блоках, окне и&nbsp;документе. Затем скрипт создает карту состояний для каждого слоя. Карта содержит размеры слоя, блоков и&nbsp;позиции их&nbsp;пересечений при скролле.</p>
<p>После сбора информации скрипт копирует все блоки в&nbsp;маскирующий контейнер и&nbsp;применяет к&nbsp;каждому классы, переданные в&nbsp;настройках. Если вы&nbsp;добавили навигацию, то&nbsp;иммёрсер создаст ссылки на&nbsp;каждый слой.</p>
<p>Затем иммёрсер подписывается на&nbsp;события скролла документа и&nbsp;изменения размеров окна.</p>
<p>При скролле иммёрсер двигает маскирующий контейнер так, чтобы показывать часть каждой группы блоков для каждого слоя под ними. При изменении размеров окна скрипт рассчитает карту состояний заново.</p>
`,

  'options-title': 'Настройки',
  'options-content': `
<p>
  Вы&nbsp;можете передать настройки параметром функции конструктора или дата-атрибутом в&nbsp;документе.
  Дата-аттрибут обрабатывается последним, поэтому он&nbsp;переопределит настройки, переданные в&nbsp;конструктор.
</p>
`,

  option: 'параметр',
  type: 'тип',
  default: 'значение по умолчанию',
  description: 'описание',

  'option-solidClassnameArray':
    'Массив настроек слоев. Конфигурация, переданная в data-immerser-layer-config перезапишет эту настройку для соответствующего слоя. Пример конфигурации <a href="#initialize-immerser">показан выше</a>',
  'option-fromViewportWidth': 'Минимальная ширина окна для инициализации иммёрсера',
  'option-pagerThreshold': 'Насколько должен следующий слой быть видим в окне, чтобы он стал активен в навигации',
  'option-hasToUpdateHash': 'Флаг, контролирующий обновление хеша страницы',
  'option-scrollAdjustThreshold':
    'Дистанция до&nbsp;верха или низа окна браузера в&nbsp;пикселях. Если текущая дистанция меньше переданного значения, то&nbsp;скрипт подстроит положение скролла',
  'option-scrollAdjustDelay': 'Сколько ждать бездействия пользователя, чтобы начать подстройку скролла',
  'option-pagerLinkActiveClassname': 'Применяется, к каждой ссылке пейджера, ссылающуюся на активный слой',
  'option-isScrollHandled': 'Подписывается на событие прокрутки, если включено. Выключите в случае, когда скроллом управляет внешний контроллер',
  'option-onInit': 'Колбек после инициализации. Принимает один параметр — экземпляр иммёрсера',
  'option-onBind': 'Колбек после привязки к документу. Принимает один параметр — экземпляр иммёрсера',
  'option-onUnbind': 'Колбек после отвязки от документа. Принимает один параметр — экземпляр иммёрсера',
  'option-onDestroy': 'Колбек после уничтожения. Принимает один параметр — экземпляр иммёрсера',
  'option-onActiveLayerChange':
    'Колбек после смены активного слоя. Принимает два параметра: индекс следующего слоя и экземпляр иммёрсера',

  'cloning-event-listeners-title': 'Клонирование подписчиков событий',
  'cloning-event-listeners-content': `
<p>
  Вы&nbsp;уже знаете, что иммёрсер клонирует элементы.
  Подписчики событий и&nbsp;данные, привязанные к&nbsp;нодам, не&nbsp;клонируются вместе с&nbsp;элементом.
  К&nbsp;счастью, вы&nbsp;можете разметить иммёрсер самостоятельно.
  Для этого разместите внутри корневого элемента маскирующие контейнеры для блоков по&nbsp;числу слоев.
  В&nbsp;таком случае скрипт не&nbsp;будет клонировать элементы. Подписчики и&nbsp;реактивная логика останутся нетронутыми.
  В&nbsp;примере на&nbsp;этой странице я&nbsp;создаю подписчик на&nbsp;клик по&nbsp;смайлу справа до&nbsp;инициализации.
</p>
`,

  'your-markup': 'ваша разметка',

  'handle-clone-hover-title': 'Обработка наведения на границах слоев',
  'handle-clone-hover-content': `
<p>
  Если вы&nbsp;наведете мышь на&nbsp;элемент, находящийся на&nbsp;границе слоев,
  то&nbsp;псевдоселектор <code>:hover</code> сработает только на&nbsp;одну часть.
  Чтобы наведение сработало на&nbsp;все клоны элемента, задайте идентификатор наведения в&nbsp;атрибуте <code>data-immerser-synchro-hover="hoverId"</code>.
  При наведении мыши на&nbsp;такой элемент, ко&nbsp;всем его клонам добавится класс <code>_hover</code>.
  Стилизуйте по&nbsp;этому селектору вместе с&nbsp;псевдоселектором <code>:hover</code>, чтобы добиться нужного эффекта.
</p>
`,
  'handle-dom-change-title': 'Обработка изменения документа',
  'handle-dom-change-content': `
<p>
  Иммёрсер не отслеживает изменения документа, если вы динамически добавляете или удаляете ноды. Если вы меняете высоту документа,
  и хотите, чтобы иммёрсер пересчитал и перерисовал блоки, вызовите метод <code>onDOMChange</code> у экземпляра иммёрсера.
</p>
`,
};
