import { Html, Head, Main, NextScript } from "next/document";

function Document() {
  return (
    <Html>
      <Head>
        <link
          rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"
        />
        <meta
          name="google-site-verification"
          content="YLmEePwtDgG0Mk5y1QKFyUwYw-1S1xXkkfSVSpL78Rc"
        />
        <script
          async
          src="https://www.googletagmanager.com/gtag/js?id=G-NB19BHZ97M"
        ></script>
        <script
          dangerouslySetInnerHTML={{
            __html: `
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
          
            gtag('config', 'G-NB19BHZ97M');
				`,
          }}
        />
        <script
          type="application/ld+json"
          dangerouslySetInnerHTML={{
            __html: `{"@context" : "http://schema.org",
  "@type" : "Organization",
  "name" : "Softwind Tech Ltd",
 "url" : "https://www.softwindtech.com/",
 "sameAs" : [
   "https://www.youtube.com/user/SoftwindTech",
   "https://www.facebook.com/SoftWindTech/",
   "https://bd.linkedin.com/in/softwind-tech-76447a63"
   ],
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "House: 73, Road-13/A, Block: D, Banani", 
    "addressRegion": "Dhaka",
    "postalCode": "1213",
    "addressCountry": Bangladesh",
  }}`,
          }}
        ></script>
      </Head>
      <body>
        <Main />
        <NextScript />
      </body>
    </Html>
  );
}

export default Document;
