import React, { Fragment } from "react";
import { Col, Container, Row } from "react-bootstrap";
import { HiArrowRight, HiArrowLeft } from "react-icons/hi";
import { translateText } from "../../common/helpers";

function ServiceSingle({ locale, service }) {
  return (
    <Fragment>
      <Container className="website_design_details px-4 px-lg-2 ">
        <h2 className="l_title">{translateText(locale, service)}</h2>
        {/* -------- Sticky Nav Holder Start ------------ */}
        {/* <div className="sticky_nav d-none d-lg-block">
          <div className="px-4 sticky_nav_holder d-flex justify-content-between align-items-center">
            <div>
              <p className="s_title">Next Post</p>
              <h4 className="s_h_title">Progressive Web App</h4>
            </div>
            <div className="next_preview_btn">
              <div className="d-flex btn_position">
                <button className="circle">
                  <span>
                    <HiArrowLeft />
                  </span>
                </button>
                <button className="circle">
                  <span>
                    <HiArrowRight />
                  </span>
                </button>
              </div>
            </div>
          </div>
        </div> */}
        {/* -------- Sticky Nav Holder End ------------ */}
        <Row>
          <Col className="px-xl-5 py-4">
            <Row>
              <Col
                className="top_des"
                dangerouslySetInnerHTML={{
                  __html: translateText(locale, service, "excerpt"),
                }}
              ></Col>
            </Row>

            <Row className="section_margin mx-0">
              <Col lg={6} className="bg_gray flex_center px-3 px-sm-4 py-5">
                <div
                  className="px-0 px-xl-5"
                  dangerouslySetInnerHTML={{
                    __html: translateText(locale, service, "content"),
                  }}
                ></div>
              </Col>
              <Col lg={6} className="px-0 img_section">
                <img className="img_fit" src={service.banner} alt="" />
              </Col>
            </Row>

            <Row>
              <Col
                dangerouslySetInnerHTML={{
                  __html: translateText(locale, service, "ext_content"),
                }}
              ></Col>
            </Row>
            <Row className="get_quote_section section_margin bg_dark text_white p-3 p-md-4 ">
              <Col className="get_quote_section_inner flex_between_a_top">
                <div>
                  <h2 className="h_title">
                    Want to set up <br /> your business today?
                  </h2>
                  <p className="sub_title">
                    Create a High Performed UI/UX Design from a Silicon Valley.
                  </p>
                </div>
                <button type="button" className="btnStyle">
                  Get A Quote
                  <span>
                    <HiArrowRight />
                  </span>
                </button>
              </Col>
            </Row>
            {/* <Row className="next_project_btn_section d-lg-none py-4">
              <Col className="d-flex justify-content-between align-items-center">
                <div>
                  <p className="s_title">Next Post</p>
                  <h4 className="s_h_title">Progressive Web App</h4>
                </div>
                <div className="next_preview_btn">
                  <div className="d-flex btn_position">
                    <button className="circle">
                      <span>
                        <HiArrowLeft />
                      </span>
                    </button>
                    <button className="circle">
                      <span>
                        <HiArrowRight />
                      </span>
                    </button>
                  </div>
                </div>
              </Col>
            </Row> */}
          </Col>
        </Row>
      </Container>
    </Fragment>
  );
}

export default ServiceSingle;
