import React, { Fragment } from "react";
import { Container } from "react-bootstrap";
import AboutSWT from "../../components/AboutSWT";
import SatisfiedClients from "../../components/SatisfiedClients";
import PageTop from "../../components/PageTop";
import QuickDiscussion from "../../components/QuickDiscussion";
import AboutApproachStats from "../../components/AboutApproachStats";
import AboutSwtVideo from "../../components/AboutSwtVideo";
import SummarySection from "../../components/SummarySection";
import Head from "next/head";
import { translateText } from "../../common/helpers";
function About({ page, locale }) {
  const {
    items: { approach, campaign, statistics, video, service, client },
    meta,
  } = page;
  return (
    <Fragment>
      <Head>
        <title>{translateText(locale, meta)}</title>
      </Head>
      <PageTop
        subTitle={translateText(locale, page, "subtitle")}
        title={translateText(locale, page, "excerpt")}
      />
      <Container
        fluid={true}
        className="about_swt"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        {service && <AboutSWT service={service} locale={locale} />}
        <AboutApproachStats
          approach={approach}
          statistics={statistics}
          locale={locale}
        />
      </Container>
      <SatisfiedClients client={client} locale={locale} />
      <AboutSwtVideo video={video} locale={locale} />
      <SummarySection campaign={campaign} locale={locale} />
      <QuickDiscussion />
    </Fragment>
  );
}

export default About;
