import React, { Fragment } from "react";
import { Container, Row } from "react-bootstrap";
import PageTop from "../../components/PageTop";
import Head from "next/head";
import { translateText } from "../../common/helpers";
const Default = ({ page, locale }) => {
  const { meta } = page;
  return (
    <Fragment>
      <Head>
        <title>
          {translateText(locale, meta) || translateText(locale, page)}
        </title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <PageTop
        subTitle={translateText(locale, page, "subtitle")}
        title={translateText(locale, page)}
      />
      <Container>
        <Row
          className="mx-2 pb-3 pb-lg-5 default-content"
          dangerouslySetInnerHTML={{
            __html: translateText(locale, page, "content"),
          }}
        />
      </Container>
    </Fragment>
  );
};

export default Default;
