import React, { Fragment } from "react";
import { Container, Nav } from "react-bootstrap";
import { NavLink } from "../../components/NavLink";
import { RiPencilRulerLine, RiTerminalWindowLine } from "react-icons/ri";
import { BsCheck2, BsWindow } from "react-icons/bs";
import { HiArrowLeft } from "react-icons/hi";
import { translateText, safeParseJSON } from "../../common/helpers";
import Head from "next/head";
import ServiceIconSvg from "../../components/ServiceIconSvg";
import Link from "next/link";
import BackButton from "./../../components/BackButton";
import Fade from "react-reveal/Fade";

function Services({ page, locale }) {
  const {
    items: { service },
    meta,
  } = page;

  return (
    <Fragment>
      <Head>
        <title>{translateText(locale, meta)}</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <Container
        className="service_page_section section_margin px-3 px-xl-4"
        data-immerser-layer
        data-immerser-layer-config='{"left_scroll": "left_scroll_color_black"}'
      >
        <BackButton />
        <div className="my-3 my-lg-5 section_title">
          <h2 className="h_title">{translateText(locale, page)}</h2>
        </div>
        <Nav className="breadcrumb_section">
          <ol className="breadcrumb bg-transparent pl-0">
            <li className="breadcrumb-item">
              <NavLink to="/">Home</NavLink>
            </li>
            <li className="breadcrumb-item active">
              {translateText(locale, page)}
            </li>
          </ol>
        </Nav>

        <div className="service_card d-flex justify-content-center flex-wrap my-4 my-lg-5">
          {service.map((singleService, idx) => {
            return (
              <Fade bottom duration={1000} key={singleService.slug}>
                <div className="card">
                  {singleService.icon.includes(".svg") ? (
                    <ServiceIconSvg
                      iconurl={singleService.icon}
                      className="card-img-top"
                    />
                  ) : (
                    <img
                      src={singleService.icon}
                      className="card-img-top"
                    ></img>
                  )}

                  <div className="card-body">
                    <h4 className="card-title">
                      {translateText(locale, singleService)}
                    </h4>
                    <p className="card-text">
                      {translateText(locale, singleService, "sub_title")}
                    </p>
                    <ul>
                      {singleService[`keywords_${locale}`]?.map(
                        (keyword: string, idx: number) => {
                          return (
                            <li key={idx}>
                              <span>
                                <BsCheck2 />
                              </span>
                              {keyword}
                            </li>
                          );
                        }
                      )}
                    </ul>
                    <Link href={`/individuals/service/${singleService.slug}`}>
                      <a className="btnStyle"> Read More</a>
                    </Link>
                  </div>
                </div>
              </Fade>
            );
          })}
        </div>
      </Container>
    </Fragment>
  );
}

export default Services;
